% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{dBeta.4P}
\alias{dBeta.4P}
\title{Probability Density under the Four-Parameter Beta Probability Density Distribution.}
\usage{
dBeta.4P(x, l, u, alpha, beta)
}
\arguments{
\item{x}{Value of \code{x}.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}
}
\value{
The value for the probability density at specified values of \code{x}.
}
\description{
Gives the density at desired values of \code{x} under the Four-Parameter Beta Probability Density Distribution.
}
\examples{
# Assume some variable follows a four-parameter Beta distribution with
# location parameters l = 0.25 and u = 0.75, and shape parameters alpha = 5
# and beta = 3. To compute the probability density at a specific point of
# the distribution (e.g., 0.5) using dBeta.4P():
dBeta.4P(x = 0.5, l = 0.25, u = 0.75, alpha = 5, beta = 3)
}
