% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{binomialmoments}
\alias{binomialmoments}
\title{Compute Moments of Binomial Probability Mass Functions.}
\usage{
binomialmoments(n, p, types = c("raw", "central", "standardized"), orders = 4)
}
\arguments{
\item{n}{Number of Binomial trials}

\item{p}{Probability of success per trial.}

\item{types}{A character vector determining which moment-types are to be calculated. Permissible values are "raw", "central", and "standardized".}

\item{orders}{The number of moment-orders to be calculated for each of the moment-types.}
}
\value{
A list of moment types, each a list of moment orders.
}
\description{
Computes Raw, Central, or Standardized moment properties of defined Binomial probability mass functions.
}
\examples{
# Assume some variable follows a Binomial distribution with number of trials
# equal to 100 and a probability of success on each trial of 0.75. To compute
# the first four raw, central, and standardized moments of this distribution
# using binomialmoments():
binomialmoments(n = 100, p = 0.75, types = c("raw", "central",
"standardized"), orders = 4)

# To only compute the (e.g.) standardized moments:
binomialmoments(n = 100, p = 0.75, types = "standardized")

# To compute moments beyond the fourth order (e.g., the sixth):
binomialmoments(n = 100, p = 0.75, orders = 6)
}
