% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{HB.beta.tp.fit}
\alias{HB.beta.tp.fit}
\title{Estimate Beta True-Score Distribution Based on Observed-Score Raw-Moments and Lord's k.}
\usage{
HB.beta.tp.fit(x, N, k, true.model = "4P", failsafe = FALSE, l = 0, u = 1)
}
\arguments{
\item{x}{Vector of observed-scores.}

\item{N}{The test length.}

\item{k}{Lord's k (see documentation for the \code{Lords.k()} function).}

\item{true.model}{The type of Beta distribution which is to be fit to the moments of the true-score distribution. Options are \code{"4P"} and \code{"2P"}, where \code{"4P"} refers to the four-parameter (with the same mean, variance, skewness, and kurtosis), and \code{"2P"} the two-parameter solution where both location-parameters are specified (with the same mean and variance).}

\item{failsafe}{Logical. Whether to revert to a fail-safe two-parameter solution should the four-parameter solution contain invalid parameter estimates.}

\item{l}{If \code{failsafe = TRUE} or \code{true.model = "2P"}: The lower-bound of the Beta distribution. Default is 0 (i.e., the lower-bound of the Standard, two-parameter Beta distribution).}

\item{u}{If \code{failsafe = TRUE} or \code{true.model = "2P"}: The upper-bound of the Beta distribution. Default is 1 (i.e., the upper-bound of the Standard, two-parameter Beta distribution).}
}
\value{
A list with the parameter values of a four-parameter Beta distribution. "l" is the lower location-parameter, "u" the upper location-parameter, "alpha" the first shape-parameter, and "beta" the second shape-parameter. Also includes Lord's k and the test length.
}
\description{
Estimator for the Beta true-score distribution shape-parameters from the observed-score distribution and Lord's k. Returns a list with entries representing the lower- and upper shape parameters (l and u), and the shape parameters (alpha and beta) of the four-parameters beta distribution, as well as Lord's k and the test length.
}
\examples{
# Generate some fictional data. Say 1000 individuals take a 100-item test
# where all items are equally difficult, and the true-score distribution
# is a four-parameter Beta distribution with location parameters l = 0.25,
# u = 0.75, alpha = 5, and beta = 3, and the error distribution is Binomial
# with Lord's k = 0:
set.seed(12)
testdata <- rbinom(1000, 100, rBeta.4P(1000, 0.25, 0.75, 5, 3))

# To estimate the four-parameter Beta distribution parameters from this
# sample of observations:
HB.beta.tp.fit(testdata, 100, 0)
}
\references{
Hanson, B. A. (1991). Method of Moments Estimates for the Four-Parameter Beta Compound Binomial Model and the Calculation of Classification Consistency Indexes. American College Testing Research Report Series. Retrieved from https://files.eric.ed.gov/fulltext/ED344945.pdf

Lord, F. M. (1965). A strong true-score theory, with applications. Psychometrika. 30(3). pp. 239--270. doi: 10.1007/BF02289490
}
