% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_topics_over_time.R
\name{visualize_topics_over_time}
\alias{visualize_topics_over_time}
\title{Visualize Topics Over Time using BERTopic}
\usage{
visualize_topics_over_time(
  model,
  topics_over_time_model,
  top_n_topics = 20,
  filename = "topics_over_time"
)
}
\arguments{
\item{model}{A BERTopic model object. The model must have the method \code{visualize_topics_over_time}.}

\item{topics_over_time_model}{A topics-over-time model object created using the BERTopic model.}

\item{top_n_topics}{An integer specifying the number of top topics to display in the visualization. Default is 20.
Must be a positive integer.}

\item{filename}{A character string specifying the name of the HTML file to save the visualization.
The default value is "topics_over_time". The filename should not contain illegal characters.}
}
\value{
The function does not return a value but saves an HTML file containing the visualization
and displays it in the current R environment.
}
\description{
This function visualizes topics over time from a BERTopic model using Python's Plotly library.
The visualization is saved as an interactive HTML file, which can be opened and viewed in a web browser.
}
\examples{
\donttest{
if (exists("topic_model") && exists("topics_over_time")) {
  visualize_topics_over_time(model = topic_model,
                             topics_over_time_model = topics_over_time,
                             top_n_topics = 5,
                             filename = "plot")
} else {
  message("No topic_model/topics_over_time found. Train a model first.")
}
}
}

