% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr_prior.R
\name{calc_power_prior_beta}
\alias{calc_power_prior_beta}
\title{Calculate Power Prior Beta}
\usage{
calc_power_prior_beta(external_data, response, prior)
}
\arguments{
\item{external_data}{This can either be a \code{prop_scr_obj} created by calling
\code{create_prop_scr()} or a tibble of the external data. If it is just a
tibble the weights will be assumed to be 1.}

\item{response}{Name of response variable}

\item{prior}{A beta distributional object that is the initial prior for the
control response rate before the external control data are observed}
}
\value{
Beta power prior object
}
\description{
Calculate a (potentially inverse probability weighted) beta
power prior for the control response rate using external control data.
}
\details{
Weighted participant-level response data from the control arm of an
external study are incorporated into an inverse probability weighted (IPW)
power prior for the control response rate \eqn{\theta_C}. When borrowing
information from an external control arm of size \eqn{N_{EC}}, the components
of the IPW power prior for \eqn{\theta_C} are defined as follows:
\describe{
\item{Initial prior:}{\deqn{\theta_C \sim \mbox{Beta}(\nu_0, \phi_0)}}
\item{IPW likelihood of the external response data \eqn{\boldsymbol{y}_E} with
weights \eqn{\hat{\boldsymbol{a}}_0}:}{\deqn{\mathcal{L}_E(\theta_C \mid
    \boldsymbol{y}_E, \hat{\boldsymbol{a}}_0) \propto \exp \left( \sum_{i=1}^{N_{EC}}
    \hat{a}_{0i} \left[ y_i \log(\theta_C) + (1 - y_i) \log(1 - \theta_C) \right] \right)}}
\item{IPW power prior:}{\deqn{\theta_C \mid \boldsymbol{y}_E, \hat{\boldsymbol{a}}_0
    \sim \mbox{Beta} \left( \sum_{i=1}^{N_{EC}} \hat{a}_{0i} y_i + \nu_0,
    \sum_{i=1}^{N_{EC}} \hat{a}_{0i} (1 - y_i) + \phi_0 \right)}}
}

Defining the weights \eqn{\hat{\boldsymbol{a}}_0} to equal 1 results in a
conventional beta power prior.
}
\examples{
library(distributional)
library(dplyr)
# This function can be used directly on the data
calc_power_prior_beta(external_data = ex_binary_df,
                      response = y,
                      prior = dist_beta(0.5, 0.5))

# Or this function can be used with a propensity score object
ps_obj <- calc_prop_scr(internal_df = filter(int_binary_df, trt == 0),
                        external_df = ex_binary_df,
                        id_col = subjid,
                        model = ~ cov1 + cov2 + cov3 + cov4)

calc_power_prior_beta(ps_obj,
                      response = y,
                      prior = dist_beta(0.5, 0.5))
}
\seealso{
Other power prior: 
\code{\link{calc_power_prior_norm}()},
\code{\link{calc_power_prior_weibull}()}
}
\concept{power prior}
