% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simplex}
\alias{simplex}
\title{Simulated beadplex data}
\format{
A list with three elements. Each element is a \code{data.frame} of 3000 to 9000 rows. The exact format depends on the assay simulated:
\describe{
\item{lplex}{
Simulated LEGENDplex data. A single \code{data.frame} with the columns:
\describe{
\item{FSC}{The forward scatter parameter}
\item{SSC}{The side scatter parameter}
\item{APC}{Intensity in the APC channel}
\item{PE}{Intensity in the PE channel}
}
}
\item{mplex}{
Simulated MACSPlex data. A single \code{data.frame} with the columns:
\describe{
\item{FSC}{The forward scatter parameter}
\item{SSC}{The side scatter parameter}
\item{FITC}{Intensity in the FITC channel}
\item{PE}{Intensity in the PE channel}
\item{APC}{Intensity in the PE channel}
}
}
\item{cba}{
Simulated CBA data. A single \code{data.frame} with the columns:
\describe{
\item{FSC}{The forward scatter parameter}
\item{SSC}{The side scatter parameter}
\item{APC}{Intensity in the APC channel}
\item{APC-Cy7}{Intensity in the APC-Cy7 channel}
\item{PE}{Intensity in the PE channel}
}
}
}
}
\source{
Artificial
}
\usage{
data(simplex)
}
\description{
Very simple, simulated multiplex data to demonstrate the clustering
functionality of the \strong{beadplexr} package on CBA and MACSPlex assays.
}
\keyword{datasets}
