% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbw.R
\docType{package}
\name{bbw}
\alias{bbw-package}
\alias{bbw}
\title{Blocked Weighted Bootstrap}
\description{
The \strong{blocked weighted bootstrap (BBW)} is an estimation technique for
use with data from two-stage cluster sampled surveys in which either prior
weighting (e.g. \strong{population proportional sampling} or \strong{PPS} as
used in \strong{Standardized Monitoring and Assessment of Relief and
Transitions} or \strong{SMART} surveys) or posterior weighting (e.g. as used in
\strong{Rapid Assessment Method} or \strong{RAM} and \strong{Simple Spatial Sampling Method}
or \strong{S3M} surveys).
}
\details{
The bootstrap technique is described in this
\href{https://en.wikipedia.org/wiki/Bootstrapping_(statistics)}{article}.
The BBW used in RAM and S3M is a modification to the \emph{percentile bootstrap}
to include \strong{blocking} and \strong{weighting} to account for a complex sample
design.

With RAM and S3M surveys, the sample is complex in the sense that it is an
unweighted cluster sample. Data analysis procedures need to account for the
sample design. A blocked weighted bootstrap (BBW) can be used:
\itemize{
\item \strong{Blocked} - The block corresponds to the primary sampling unit
\code{PSU = cluster}. PSUs are resampled with replacement. Observations within the
resampled PSUs are also sampled with replacement.
\item \strong{Weighted} - RAM and S3M samples do not use population proportional
sampling (PPS) to weight the sample prior to data collection (e.g. as is done
with SMART surveys). This means that a posterior weighting procedure is
required. \code{{bbw}} uses a \strong{"roulette wheel"} algorithm to weight (i.e. by
population) the selection probability of PSUs in bootstrap replicates.
}

In the case of prior weighting by PPS all clusters are given the same weight.
With posterior weighting (as in RAM or S3M) the weight is the population of
each PSU. This procedure is very similar to the
\href{https://en.wikipedia.org/wiki/Fitness_proportionate_selection}{fitness proportionate selection}
technique used in evolutionary computing.

A total of \code{m} PSUs are sampled with replacement for each bootstrap replicate
(where \code{m} is the number of PSUs in the survey sample).

The required statistic is applied to each replicate. The reported estimate
consists of the \strong{0.025th (95\% LCL)}, \strong{0.5th (point estimate)}, and
\strong{0.975th (95\% UCL)} quantiles of the distribution of the statistic across
all survey replicates.

Early versions of the \code{{bbw}} package did not resample observations within
PSUs following:

\cite{Cameron AC, Gelbach JB, Miller DL, Bootstrap-based improvements for
inference with clustered errors, Review of Economics and Statistics,
2008:90;414–427 \doi{10.1162/rest.90.3.414}}

and used a large number (e.g. 3999) survey replicates. Current versions of
the \code{{bbw}} package resample observations within PSUs and use a smaller
number of survey replicates (e.g. \code{n = 400}). This is a more computationally
efficient approach
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rapidsurveys/bbw}
  \item \url{https://rapidsurveys.io/bbw/}
  \item Report bugs at \url{https://github.com/rapidsurveys/bbw/issues}
}

}
\author{
\strong{Maintainer}: Ernest Guevarra \email{ernestgmd@gmail.com} (\href{https://orcid.org/0000-0002-4887-4415}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Mark Myatt \email{mark@brixtonhealth.com} (\href{https://orcid.org/0000-0003-1119-1474}{ORCID}) [copyright holder]
}

}
\keyword{internal}
