% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.r
\name{bb.summary.stat}
\alias{bb.summary.stat}
\title{Prints out the summary statistics of bull-bear states}
\usage{
bb.summary.stat(price, bull)
}
\arguments{
\item{price}{a numeric vector of price values}

\item{bull}{a logical vector that contains the states of the market. This vector
is returned by function \code{\link{run_dating_alg}} or \code{\link{run_filtering_alg}}.}
}
\value{
A data frame that contains the descriptive statistics.
}
\description{
This function prints out (in console window) the summary statistics of bull-bear states.
The outcome of this function is a table in LaTeX format.
}
\examples{
{
library(zoo)
library(xtable)
library(ggplot2)
sp500 <- sp500m # choose the monthly data
price <- as.vector(coredata(sp500)) # retrieve prices
setpar_dating_alg(4, 6, 4, 16, 20) # parameters for monthly data
bull <- run_dating_alg(price) # detect the states
bb.summary.stat(price, bull)
}
}
