# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib bbdetection
NULL

#' Sets the paramters of the filtering algorithm
#'
#' This function sets the paramters of the filtering algorithm of Lunde and Timmermann (2004)
#'
#' @param tr_bull threshold to idenitfy a Bull state (in percentages)
#' @param tr_bear threshold to idenitfy a Bear state (in percentages)
#' @return None
#' @usage setpar_filtering_alg(tr_bull, tr_bear)
#' @references
#' Lunde, A. and Timmermann, A. (2004). Duration Dependence in Stock Prices: An Analysis
#' of Bull and Bear Markets. Journal of Business and Economic Statistics, 22 (3), 253-273.
#' @export
setpar_filtering_alg <- function(tr_bull = 30, tr_bear = 20) {
    invisible(.Call('_bbdetection_setpar_filtering_alg', PACKAGE = 'bbdetection', tr_bull, tr_bear))
}

#' Runs the filtering algorithm to identify Bull and Bear states
#'
#' This function implements the filtering algorithm of Lunde and Timmermann (2004) to identify Bull and Bear states
#'
#' @param index vector containing the stock price index
#' @return A logical vector that contains TRUE for Bull states and FALSE for Bear states
#' @note Be aware that the states in the beginning and in the end of \code{"index"} are not properly defined
#' @usage run_filtering_alg(index)
#' @references
#' Lunde, A. and Timmermann, A. (2004). Duration Dependence in Stock Prices: An Analysis
#' of Bull and Bear Markets. Journal of Business and Economic Statistics, 22 (3), 253-273.
#' @export
run_filtering_alg <- function(index) {
    .Call('_bbdetection_run_filtering_alg', PACKAGE = 'bbdetection', index)
}

#' Sets the paramters of the dating algorithm
#'
#' This function sets the paramters of the dating algorithm of Bry and Boschan (1971)
#'
#' @param t_window the half-size of the rolling window to find minima and maxima
#' @param t_censor the size of the left and right margin (for the cencoring operation)
#' @param t_phase the minimum phase (bull or bear) length
#' @param t_cycle the minimum full cycle length
#' @param max_chng the change (in percentages) in the \code{"index"} that invalidates the minimum phase length rule
#' @return None
#' @note All parameters but \code{"max_chng"} are given in a number of observations.
#' For example, if data are at the monthly frequency, \code{"t_cycle=16"} defines that the minimum cycle length should be 16 months.
#' @usage setpar_dating_alg(t_window, t_censor, t_phase, t_cycle, max_chng)
#' @references
#' Bry, G. and Boschan, C. (1971). Cyclical Analysis of Time Series: Selected Procedures and
#' Computer Programs. NBER.
#'
#' Pagan, A. R. and Sossounov, K. A. (2003). A Simple Framework for Analysing Bull and Bear
#' Markets. Journal of Applied Econometrics, 18 (1), 23-46.
#'
#' Gonzalez, L., Powell, J. G., Shi, J., and Wilson, A. (2005). Two Centuries of Bull and Bear
#' Market Cycles. International Review of Economics and Finance, 14 (4), 469-486.
#' @export
setpar_dating_alg <- function(t_window = 8L, t_censor = 6L, t_phase = 4L, t_cycle = 16L, max_chng = 20) {
    invisible(.Call('_bbdetection_setpar_dating_alg', PACKAGE = 'bbdetection', t_window, t_censor, t_phase, t_cycle, max_chng))
}

#' Runs the dating algorithm to identify Bull and Bear states
#'
#' This function implements the dating algorithm of Bry and Boschan (1971) to identify Bull and Bear states
#'
#' @param index vector containing the stock price index
#' @return A logical vector that contains TRUE for Bull states and FALSE for Bear states
#' @note Be aware that the states in the beginning and in the end of \code{"index"} are not properly defined.
#' The users are advised to always visually check the correctness of the result
#' (during Bull states the prices should generally increase, during the Bear states decrease).
#' @usage run_dating_alg(index)
#' @references
#' Bry, G. and Boschan, C. (1971). Cyclical Analysis of Time Series: Selected Procedures and
#' Computer Programs. NBER.
#'
#' Pagan, A. R. and Sossounov, K. A. (2003). A Simple Framework for Analysing Bull and Bear
#' Markets. Journal of Applied Econometrics, 18 (1), 23-46.
#'
#' Gonzalez, L., Powell, J. G., Shi, J., and Wilson, A. (2005). Two Centuries of Bull and Bear
#' Market Cycles. International Review of Economics and Finance, 14 (4), 469-486.
#' @export
run_dating_alg <- function(index) {
    .Call('_bbdetection_run_dating_alg', PACKAGE = 'bbdetection', index)
}

