% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_beta_tmg}
\alias{plot_beta_tmg}
\title{Plot beta(TMG_t) evolution by sector}
\usage{
plot_beta_tmg(results, sectors = NULL)
}
\arguments{
\item{results}{List returned by \code{\link{fit_ou_nonlinear_tmg}}}

\item{sectors}{Character or integer vector. Sectors to plot.
If NULL, plots all sectors.}
}
\value{
A ggplot2 object if ggplot2 is available, otherwise NULL
  with a base R plot produced as side effect.
}
\description{
Creates a line plot showing the evolution of time-varying beta
coefficients for selected sectors.
}
\examples{
\donttest{
# 1. Create mock data (T x S matrix)
T_obs <- 50
S <- 3
beta_mat <- matrix(rnorm(T_obs * S), nrow = T_obs, ncol = S)
colnames(beta_mat) <- paste0("Sector_", 1:S)

# 2. Wrap in list structure expected by function
results_mock <- list(
  beta_tmg = list(
    beta_point = beta_mat
  )
)

# 3. Plot
plot_beta_tmg(results_mock)
}

}
