% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{extract_convergence_evidence}
\alias{extract_convergence_evidence}
\title{Extract convergence evidence for kappa parameters}
\usage{
extract_convergence_evidence(fit_res, verbose = TRUE)
}
\arguments{
\item{fit_res}{List returned by \code{\link{fit_ou_nonlinear_tmg}}}

\item{verbose}{Logical. Print summary to console. Default TRUE.}
}
\value{
List with components:
  \describe{
    \item{kappa_ic95}{Matrix (S x 3) with columns q2.5, median, q97.5}
    \item{convergence}{Logical indicating if all kappa in (0,1)}
    \item{prob_convergence}{Posterior probability of joint convergence}
  }
}
\description{
Computes 95 percent credible intervals for each kappa_s (mean reversion speed)
and verifies formal convergence conditions.
}
\examples{
\donttest{
# 1. Create a mock fit object with kappa draws
# kappa_tilde is log(kappa), so we use log(0.5) roughly -0.69
n_draws <- 100
S <- 2
kappa_tilde_draws <- matrix(rnorm(n_draws * S, mean = -0.7, sd = 0.1), 
                            nrow = n_draws, ncol = S)
colnames(kappa_tilde_draws) <- c("kappa_tilde[1]", "kappa_tilde[2]")

mock_fit <- structure(list(
  draws = function(vars, format="matrix") {
    if (vars == "kappa_tilde") return(kappa_tilde_draws)
    return(NULL)
  }
), class = "CmdStanMCMC")

# 2. Wrap in the results list structure
results_mock <- list(
  factor_ou = list(
    stan_fit = mock_fit
  )
)

# 3. Extract evidence
conv <- extract_convergence_evidence(results_mock)
print(conv$prob_convergence)
}

}
