% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_models.R
\name{stan_ssm}
\alias{stan_ssm}
\title{Fitting an Additive linear State space model.}
\usage{
stan_ssm(
  ts,
  trend = FALSE,
  damped = FALSE,
  seasonal = FALSE,
  xreg = NULL,
  period = 0,
  genT = FALSE,
  chains = 4,
  iter = 2000,
  warmup = floor(iter/2),
  adapt.delta = 0.9,
  tree.depth = 10,
  prior_sigma0 = NULL,
  prior_level = NULL,
  prior_level1 = NULL,
  prior_trend = NULL,
  prior_trend1 = NULL,
  prior_damped = NULL,
  prior_seasonal = NULL,
  prior_seasonal1 = NULL,
  prior_breg = NULL,
  prior_df = NULL,
  series.name = NULL,
  ...
)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{trend}{a bool value to specify a trend local level model. By default
is \code{FALSE}.}

\item{damped}{a boolvalue to specify a damped trend local level model. By default
is \code{FALSE}. If \code{trend} option is \code{FALSE} then \code{damped} is set to
\code{FALSE} automatically.}

\item{seasonal}{a bool value to specify a seasonal local level model. By default
is \code{FALSE}.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{period}{an integer specifying the periodicity of the time series by
default the value frequency(ts) is used.}

\item{genT}{a bool value to specify for a generalized t-student SSM model.}

\item{chains}{an integer of the number of Markov Chains chains to be run. By
default, \code{chains = 4}.}

\item{iter}{an integer of total iterations per chain including the warm-up. By
default, \code{iter = 2000}.}

\item{warmup}{a positive integer specifying number of warm-up (aka burn-in)
iterations. This also specifies the number of iterations used for step-size
adaptation, so warm-up samples should not be used for inference. The number
of warm-up iteration should not be larger than \code{iter}.By default,
\code{warmup = iter/2}.}

\item{adapt.delta}{an optional real value between 0 and 1, the thin of the jumps
in a HMC method. By default, is 0.9.}

\item{tree.depth}{an integer of the maximum depth of the trees  evaluated
during each iteration. By default, is 10.}

\item{prior_sigma0}{The prior distribution for the scale parameter in an
ARIMA model. By default, declares a \code{student(7,0,1)} prior.}

\item{prior_level}{The prior distribution for the level parameter in a SSM model.
By default, sets a \code{normal(0,0.5)} prior.}

\item{prior_level1}{The prior distribution for the initial level parameter in
a SSM model. By default, sets a \code{student(6,0,2.5)} prior.}

\item{prior_trend}{The prior distribution for the trend parameter in a SSM model.
By default, sets a \code{normal(0,0.5)} prior.}

\item{prior_trend1}{The prior distribution for the initial trend parameter in
a SSM model. By default, sets a \code{student(6,0,2.5)} prior.}

\item{prior_damped}{The prior distribution for the damped trend parameter in a
SSM model. By default, sets a \code{normal(0,0.5)} prior.}

\item{prior_seasonal}{The prior distribution for the seasonal parameter in a
SSM model. By default, sets a \code{normal(0,0.5)} prior.}

\item{prior_seasonal1}{The prior distribution for the initial seasonal parameters
in a SSM model. The prior is specified for the first m seasonal parameters,
where \code{m} is the periodicity of the defined time series. By default, sets a
\code{normal(0,0.5)} prior.}

\item{prior_breg}{The prior distribution for the regression coefficient parameters
in an ARIMAX model. By default, sets \code{student(7,0,1)} priors.}

\item{prior_df}{The prior distribution for the degree freedom parameters in a
t-student innovations SSM model. By default, sets a \code{gamma(2,0.1)} prior}

\item{series.name}{an optional string vector with the series names.}

\item{...}{Further arguments passed to  \code{varstan} function.}
}
\value{
A \code{varstan} object with the fitted SSM model.
}
\description{
Fitting an Additive linear State space model in \pkg{Stan}.
}
\details{
The function returns a \code{varstan} object with the fitted model.

By default the \code{ssm()} function generates a local-level, \code{ets("A","N","N")},
or exponential smoothing model from the \pkg{forecast} package. When
\code{trend = TRUE} the SSM transforms into a local-trend, \code{ets("A","A","N")},
or the equivalent Holt model. For damped trend models set \code{damped = TRUE}.
If \code{seasonal = TRUE}, the model is a seasonal local level model, or
\code{ets("A","N","A")} model. Finally, the Holt-Winters method (\code{ets("A","A","A")})
is obtained by setting both \code{Trend = TRUE} and \code{seasonal = TRUE}.

The \code{genT = TRUE} option generates a t-student innovations SSM model. For
a detailed explanation, check Ardia (2010); or Fonseca, et. al (2019).

The default priors used in a \code{ssm} model are:

\itemize{
\item{level ~ normal(0,0.5)}
\item{Trend ~ normal(0,0.5)}
\item{damped~ normal(0,0.5)}
\item{Seasonal ~ normal(0,0.5)}
\item{sigma0 ~ t-student(0,1,7)}
\item{level1 ~ normal(0,1)}
\item{trend1 ~ normal(0,1)}
\item{seasonal1 ~ normal(0,1)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
\donttest{
 # Declaring a local level model for the ipc data.
 sf1 = stan_ssm(ipc,iter = 500,chains = 1)

 # Declaring a Holt model for the ipc data.
 sf2 = stan_ssm(ipc,trend = TRUE,damped = TRUE,iter = 500,chains = 1)
}

}
\references{
Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.
}
\seealso{
\code{Sarima}, \code{auto.arima}, \code{set_prior}, and \code{garch}.
}
\author{
Asael Alonzo Matamoros.
}
