% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{plot.varstan}
\alias{plot.varstan}
\title{plot methods for varstan models.}
\usage{
\method{plot}{varstan}(x, prob = 0.95, ...)
}
\arguments{
\item{x}{An object of class \code{varstan}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\eqn{90\%} intervals (\code{prob=0.9}) rather than the traditionally used
\eqn{95\%}.}

\item{...}{Further arguments passed to  \code{mcmc_combo}.}
}
\value{
None. Function produces a ggplot2 graph.
}
\description{
Preliminary plot methods for varstan models only valid for univariate time
series models. The function prints the fitted values time series, the trace
and density plots for the sampled model parameters, or the residuals'
posterior mean time series.
}
\examples{
\donttest{
 sf1 = auto.sarima(ts = birth,iter = 500,chains = 1)
 # fitted model
 plot(sf1)
}

}
