% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_factor.R
\name{bridge_sampler.varstan}
\alias{bridge_sampler.varstan}
\alias{bridge_sampler}
\title{Log Marginal Likelihood via Bridge Sampling.}
\usage{
\method{bridge_sampler}{varstan}(samples, ...)
}
\arguments{
\item{samples}{A \code{varstan} object.}

\item{...}{Additional arguments passed to
\code{\link[bridgesampling:bridge_sampler]{bridge_sampler.stanfit}}.}
}
\value{
the model's marginals likelihood from the \code{bridge_sampler} package.
}
\description{
Computes log marginal likelihood via bridge sampling,
which can be used in the computation of Bayes factors
and posterior model probabilities.
}
\details{
The \code{varstan} class is just a thin wrapper that
contains the \code{stanfit} objects.

Computing the marginal likelihood  via the bridgesampler package
for stanfit objects.

The computation of marginal likelihoods based on bridge sampling requires
a lot more posterior samples than usual. A good conservative rule of thump
is perhaps 10-fold more samples (read: the default of 4000 samples may not
be enough in many cases). If not enough posterior samples are provided, the
bridge sampling algorithm tends to be unstable leading to considerably different
results each time it is run. We thus recommend running \code{bridge_sampler}
multiple times to check the stability of the results.

For  more details check the \pkg{bridgesampling} package.
}
\examples{
\donttest{
# Fitting a seasonal ARIMA model
mod1 = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
fit1 = varstan(mod1,iter = 500,chains = 1)

fit1
bridge_sampler(fit1)

# Fitting a Dynamic harmonic regression
mod2  = Sarima(birth,order = c(0,1,2),xreg = fourier(birth,K=6))
fit2 = varstan(mod2,iter = 500,chains = 1)

fit2
bridge_sampler(fit2)
}

}
