% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_files}
\alias{convert_files}
\alias{convert_files_inplace}
\alias{convert_dir}
\alias{convert_dir_inplace}
\title{Convert files to use datasets versions of penguins and penguins_raw}
\usage{
convert_files(input, output, extensions = c("R", "r", "qmd", "rmd", "Rmd"))

convert_files_inplace(input, extensions = c("R", "r", "qmd", "rmd", "Rmd"))

convert_dir(input, output, extensions = c("R", "r", "qmd", "rmd", "Rmd"))

convert_dir_inplace(input, extensions = c("R", "r", "qmd", "rmd", "Rmd"))
}
\arguments{
\item{input}{For \code{convert_files()} and \code{convert_files_inplace()}:
A character vector of file paths to convert.
Can be relative or absolute paths.
For \code{convert_dir()} and \code{convert_dir_inplace()}:
A string with a path to a directory of files to convert.}

\item{output}{For \code{convert_files()}:
A character vector of output file paths, or \verb{NULL`` to modify files in place. If provided, must be the same length as }input\verb{. Can be absolute or relative paths. For }convert_dir()\verb{: A string with the output directory, or }NULL` to modify the files in the directory in place.}

\item{extensions}{A character vector of file extensions to process,
defaults to R scripts and R Markdown and Quarto documents.}
}
\value{
A list (returned invisibly) with two components:
\itemize{
\item \code{changed}: A character vector of paths for files that were modified.
\item \code{not_changed}: A character vector of paths for files that were not
modified. Files are not changed if they do not load the palmerpenguins
package via \code{library(palmerpenguins)}, \code{library('palmerpenguins')} or
\code{library("palmerpenguins")}, or if they do not have one of the specified
\code{extensions}.
}

For both the \code{changed} and \code{not_changed} vectors, these will be subsets of
the \code{output} paths, if they were provided, with the corresponding \code{input}
paths as names. If \code{output} was not specified, then these vectors will be
subsets of the \code{input} paths, and the vectors will not be named.
}
\description{
These functions convert files that use the
\href{https://CRAN.R-project.org/package=palmerpenguins}{palmerpenguins} package
to use the versions of \code{penguins} and \code{penguins_raw} included in the datasets
package in R >= 4.5.0. They removes calls to \code{library(palmerpenguins)} and make
necessary changes to some variable names (see Details section below).
}
\details{
Files are converted by:
\itemize{
\item Replacing \code{library(palmerpenguins)} with the empty string \code{""}
\item Replacing \code{data("penguins", package = "palmerpenguins")} with \code{data("penguins", package = "datasets")}
\item Replacing variable names:
\itemize{
\item \code{bill_length_mm} -> \code{bill_len}
\item \code{bill_depth_mm} -> \code{bill_dep}
\item \code{flipper_length_mm} -> \code{flipper_len}
\item \code{body_mass_g} -> \code{body_mass}
}
\item Replacing \code{ends_with("_mm")} with \verb{starts_with("flipper_"), starts_with"("bill_")}
}

Non-convertible files (those without the specified extensions) are copied to
the output location if \code{output} is provided, but are not modified.

If the \code{output} files or directory do not (yet) exist, they will be created
(recursively if necessary).

Replacing \code{ends_with("_mm")} with \verb{starts_with("flipper_"), starts_with("bill_")}
ensures that modified R code will always run. \code{starts_with("flipper_")} isn't
intuitively necessary, as there is only one variable starting with "flipper_",
in \code{penguins}, but this code will not error inside \verb{dplyr::(select)}, even if
\code{flipper_len} isn't in the data frame (trying to select \code{flipper_len}
directly will cause an error if that column isn't in the data frame).
In an educational context, we suggest manually editing the converted files to
replace \code{starts_with("flipper_")} to \code{flipper_len} if appropriate.
To facilitate this, the functions documented here produce a message
indicating the files and line numbers where the \code{ends_with("_mm")}
substitution was made.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
# Note that all examples below write output to a temporary directory
# and file paths are relative to that directory.

# For all examples below, use a copy of the examples provided by the package,
# copied to an "examples" directory in the working directory
example_dir("examples")

# Single file - new output
result <- convert_files("examples/penguins.R", "penguins_new.R")
cat(readLines("penguins_new.R"), sep = "\n") # view changes

# Single file - copy, then modify that in place
file.copy("examples/penguins.R", "penguins_copy.R")
convert_files_inplace("penguins_copy.R")

# Multiple files - new output locations
input_files <- c("examples/penguins.R", "examples/nested/penguins.qmd")
output_files <- output_paths(input_files, dir = "new_dir")
convert_files(input_files, output_files)

# Directory - new output location
result <- convert_dir("examples", "new_directory")
result # see `changed` and `not_changed` files

# Overwrite the files in "examples"
result <- convert_dir_inplace("examples")
result # see `changed` and `not_changed` files

\dontshow{setwd(.old_wd)}


}
\seealso{
\code{\link[=example_dir]{example_dir()}}, \code{\link[=output_paths]{output_paths()}}
}
