% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{plot_cumulative_assignment}
\alias{plot_cumulative_assignment}
\title{Plot cumulative assignment for bandit experiment.}
\usage{
plot_cumulative_assignment(results, batch_sizes)
}
\arguments{
\item{results}{List. Results of the experiment, including the actions taken (\code{ws}) and the true probabilities of each arm being chosen (\code{probs}).}

\item{batch_sizes}{Integer vector. Batch sizes used in the experiment. Must be positive integers.}
}
\value{
A plot of the cumulative assignment.
}
\description{
Generates a plot of the cumulative assignment.
}
\examples{
set.seed(123)
A <- 1000
K <- 4
xs <- matrix(runif(A * K), nrow = A, ncol = K)
ys <- matrix(rbinom(A * K, 1, 0.5), nrow = A, ncol = K)
batch_sizes <- c(250, 250, 250, 250)
results <- run_experiment(ys = ys,
                          floor_start = 1/K,
                          floor_decay = 0.9,
                          batch_sizes = batch_sizes,
                          xs = xs)
plot_cumulative_assignment(results, batch_sizes)

}
