% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_methods.R
\name{predict,bam-method}
\alias{predict,bam-method}
\alias{predict}
\alias{bam-method}
\title{Predict method of the package \pkg{bamm}.}
\usage{
\S4method{predict}{bam}(
  object,
  niche_layers,
  nbgs_vec = NULL,
  nsteps_vec,
  stochastic_dispersal = FALSE,
  disp_prop2_suitability = TRUE,
  disper_prop = 0.5,
  animate = FALSE,
  period_names = NULL,
  fmt = "GIF",
  filename,
  bg_color = "#F6F2E5",
  suit_color = "#0076BE",
  occupied_color = "#03C33F",
  png_keyword = "sdm_sim",
  ani.width = 1200,
  ani.height = 1200,
  ani.res = 300
)
}
\arguments{
\item{object}{a of class bam.}

\item{niche_layers}{A raster or RasterStack with the niche models for
each time period}

\item{nbgs_vec}{A vector with the number of neighbors for the adjacency
matrices}

\item{nsteps_vec}{Number of simulation steps for each time period.}

\item{stochastic_dispersal}{Logical. If dispersal depends on a probability of
visiting neighbor cells (Moore neighborhood).}

\item{disp_prop2_suitability}{Logical. If probability of dispersal is
proportional
to the suitability of reachable cells. The proportional value must be
declared
in the parameter `disper_prop`.}

\item{disper_prop}{Probability of dispersal to reachable cells.}

\item{animate}{Logical. If TRUE a dispersal animation on climate change
scenarios will be created}

\item{period_names}{Character vector with the names of periods that will
be animated. Default NULL.}

\item{fmt}{Animation format. Possible values are GIF and HTML}

\item{filename}{File name.}

\item{bg_color}{Color for unsuitable pixels. Default "#F6F2E5".}

\item{suit_color}{Color for suitable pixels. Default "#0076BE".}

\item{occupied_color}{Color for occupied pixels. Default "#03C33F".}

\item{png_keyword}{A keyword name for the png images generated by
the function}

\item{ani.width}{Animation width unit in px}

\item{ani.height}{Animation height unit in px}

\item{ani.res}{Animation resolution unit in px}
}
\value{
A RasterStack of predictions of dispersal dynamics as a function
of environmental change scenarios.
}
\description{
predicts species' distribution under suitability changes
}
\examples{
# rm(list = ls())
# Read raster model for Lepus californicus
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)
# Convert model to sparse
sparse_mod <- bamm::model2sparse(model = model,threshold=0.1)
# Compute adjacency matrix
adj_mod <- bamm::adj_mat(sparse_mod,ngbs=1)

# Initial points to start dispersal process

occs_lep_cal <- data.frame(longitude = c(-115.10417,
                                         -104.90417),
                           latitude = c(29.61846,
                                        29.81846))
# Convert to sparse the initial points
occs_sparse <- bamm::occs2sparse(modelsparse = sparse_mod,
                                occs = occs_lep_cal)

# Run the bam (sdm) simultation for 100 time steps
smd_lep_cal <- bamm::sdm_sim(set_A = sparse_mod,
                             set_M = adj_mod,
                             initial_points = occs_sparse,
                             nsteps = 10)
#----------------------------------------------------------------------------
# Predict species' distribution under suitability change
# scenarios (could be climate chage scenarios).
#----------------------------------------------------------------------------

# Read suitability layers (two suitability change scenarios)
layers_path <- system.file("extdata/suit_change",
                           package = "bamm")
niche_mods_stack <- raster::stack(list.files(layers_path,
                                             pattern = ".tif$",
                                             full.names = TRUE))
raster::plot(niche_mods_stack)
# Predict
new_preds <- predict(object = smd_lep_cal,
                     niche_layers = niche_mods_stack,
                     nsteps_vec = c(50,100))

# Generate the dispersal animation for time period 1 and 2
\donttest{
if(requireNamespace("animation")){
ani_prd <- tempfile(pattern = "prediction_",fileext = ".gif")
#new_preds <- predict(object = smd_lep_cal,
#                      niche_layers = niche_mods_stack,
#                      nsteps_vec = c(10,10),
#                      animate=TRUE,
#                      filename=ani_prd,
#                    fmt="GIF")

}
}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
