% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagyo-package.R, R/bagyo.R
\docType{package}
\name{bagyo}
\alias{bagyo}
\title{Philippine Tropical Cyclones Data}
\format{
A data frame with 9 columns and 86 rows:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{year} \tab Year \cr
   \emph{category_code} \tab Tropical cyclone category code \cr
   \emph{category_name} \tab Tropical cyclone category name \cr
   \emph{name} \tab Name given to the tropical cyclone by Philippine authorities \cr
   \emph{rsmc_name} \tab Name given to the tropical cyclone by RSMC \cr
   \emph{start} \tab Date and time at which cyclone enters Philippine waters \cr
   \emph{end} \tab Date and time at which cyclone leaves Philippine waters \cr
   \emph{pressure} \tab Maximum central pressure in \emph{hPa} \cr
   \emph{speed} \tab Maximum sustained wind speed in \emph{km/h} \cr
}
}
\source{
Data are drawn from PAGASA's Annual Report on Philippine Tropical
Cyclones found at
https://www.pagasa.dost.gov.ph/tropical-cyclone/publications/annual-report
}
\usage{
bagyo
}
\description{
The Philippines frequently experiences tropical cyclones (called 'bagyo' in
the Filipino language) because of its geographical position. These cyclones
typically bring heavy rainfall, leading to widespread flooding, as well as
strong winds that cause significant damage to human life, crops, and
property. Data on cyclones are collected and curated by the Philippine
Atmospheric, Geophysical, and Astronomical Services Administration (PAGASA)
and made available through its website. This package contains Philippine
tropical cyclones data in a machine-readable format. It is hoped that this
data package provides an interesting and unique dataset for data exploration
and visualisation as an adjunct to the traditional \code{iris} dataset and to the
current \code{palmerpenguins} dataset.
}
\examples{
bagyo

}
\seealso{
Useful links:
\itemize{
  \item \url{https://panukatan.io/bagyo/}
  \item \url{https://github.com/panukatan/bagyo}
  \item Report bugs at \url{https://github.com/panukatan/bagyo/issues}
}

}
\author{
\strong{Maintainer}: Ernest Guevarra \email{ernest@guevarra.io} (\href{https://orcid.org/0000-0002-4887-4415}{ORCID}) [copyright holder]

}
\keyword{datasets}
\keyword{internal}
