% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperdrive.R
\name{qlognormal}
\alias{qlognormal}
\title{Specify a normal distribution of the form
\code{round(exp(normal(mu, sigma)) / q) * q}}
\usage{
qlognormal(mu, sigma, q)
}
\arguments{
\item{mu}{A double of the mean of the normal distribution.}

\item{sigma}{A double of the standard deviation of the normal distribution.}

\item{q}{An integer of the smoothing factor.}
}
\value{
A list of the stochastic expression.
}
\description{
Specify a normal distribution of the form
\code{round(exp(normal(mu, sigma)) / q) * q}.

Suitable for a discrete variable with respect to which the objective is
smooth and gets smoother with the size of the variable, which is bounded
from one side.
}
\seealso{
\code{random_parameter_sampling()}, \code{grid_parameter_sampling()},
\code{bayesian_parameter_sampling()}
}
