% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{get_model_package_container_registry}
\alias{get_model_package_container_registry}
\title{Get the Azure container registry that a packaged model uses}
\usage{
get_model_package_container_registry(package)
}
\arguments{
\item{package}{The \code{ModelPackage} object.}
}
\value{
The \code{ContainerRegistry} object.
}
\description{
Return a \code{ContainerRegistry} object for where the image
(or base image, for Dockerfile packages) is stored in an
Azure container registry.
}
\examples{
# Given a ModelPackage object,
# get the container registry information
\dontrun{
container_registry <- get_model_package_container_registry(package)
address <- container_registry$address
username <- container_registry$username
password <- container_registry$password
}

# To then authenticate Docker with the Azure container registry from
# a shell or command-line session, use the following command, replacing
# <address>, <username>, and <password> with the values retrieved
# from above:
# ```bash
# docker login <address> -u <username> -p <password>
# ```
}
\seealso{
\code{container_registry()}
}
