% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{define_timestamp_columns_for_dataset}
\alias{define_timestamp_columns_for_dataset}
\title{Define timestamp columns for the dataset.}
\usage{
define_timestamp_columns_for_dataset(
  dataset,
  fine_grain_timestamp,
  coarse_grain_timestamp = NULL,
  validate = FALSE
)
}
\arguments{
\item{dataset}{The Tabular Dataset object.}

\item{fine_grain_timestamp}{The name of column as fine grain timestamp. Use None to clear it.}

\item{coarse_grain_timestamp}{The name of column coarse grain timestamp (optional).
The default is None.}

\item{validate}{Indicates whether to validate if specified columns exist in dataset.
The default is False. Validation requires that the data source is accessible
from the current compute.}
}
\value{
The Tabular Dataset with timestamp columns defined.
}
\description{
Define timestamp columns for the dataset.
The method defines columns to be used as timestamps. Timestamp columns on a dataset
make it possible to treat the data as time-series data and enable additional capabilities.
When a dataset has both \code{fine_grain_timestamp} and \verb{coarse_grain_timestamp defined}
specified, the two columns should represent the same timeline.
}
