% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-clients.R
\name{azr_graph_client}
\alias{azr_graph_client}
\title{Create a Microsoft Graph API Client}
\usage{
azr_graph_client(scopes = ".default", ..., chain = NULL)
}
\arguments{
\item{scopes}{A character string specifying the OAuth2 scope suffix to be appended
to the Graph API URL. Defaults to \code{".default"}, which requests all permissions
the app has been granted. The full scope will be \verb{https://graph.microsoft.com/\{scopes\}}.}

\item{...}{Additional arguments passed to the \link{api_client} constructor.}

\item{chain}{A \link{credential_chain} instance for authentication. If NULL,
a default credential chain will be created using \link{DefaultCredential}.}
}
\value{
An \link{api_service} object configured for Microsoft Graph API with
v1.0 and beta endpoints. The object is locked using \code{\link[=lockEnvironment]{lockEnvironment()}} to
prevent modification after creation. Access endpoints via \verb{$v1.0} or \verb{$beta}.
}
\description{
Creates a configured client for the Microsoft Graph API with authentication
and versioned endpoints (v1.0 and beta). This function returns an
\link{api_service} object that provides access to Microsoft Graph resources
through versioned endpoints.
}
\details{
The function creates a Microsoft Graph service using these components:
\itemize{
\item \strong{\link{api_client}}: A general-purpose API client configured with the Graph API
host URL (\verb{https://graph.microsoft.com}) and authentication provider.
\item \strong{\link{api_graph_resource}}: A specialized resource class that extends \link{api_resource}
with Microsoft Graph-specific methods. Currently implements:
\itemize{
\item \code{me(select = NULL)}: Fetch the current user's profile. The \code{select} parameter
accepts a character vector of properties to return (e.g., \code{c("displayName", "mail")}).
}
\item \strong{\link{api_service}}: A service container that combines the client and resources
with versioned endpoints (v1.0 and beta). The service is locked using
\code{\link[=lockEnvironment]{lockEnvironment()}} to prevent modification after creation.
}
}
\examples{
\dontrun{
# Create a Graph API client with default credentials
graph <- azr_graph_client()

# Fetch current user profile from v1.0 endpoint
me <- graph$v1.0$me()

# Fetch specific properties using OData $select
me <- graph$v1.0$me(select = c("displayName", "mail", "userPrincipalName"))

# Use beta endpoint for preview features
me_beta <- graph$beta$me(select = c("displayName", "mail"))

# Create with a custom credential chain
custom_chain <- credential_chain(
  AzureCLICredential$new(scope = "https://graph.microsoft.com/.default")
)
graph <- azr_graph_client(chain = custom_chain)

# Use specific scopes instead of .default
graph <- azr_graph_client(scopes = "User.Read Mail.Read")
}
}
