% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat_bulk_save.R
\name{ggstrat_bulk_save}
\alias{ggstrat_bulk_save}
\title{Bulk save stratigraphic plots for all uploaded sections}
\usage{
ggstrat_bulk_save(
  df,
  plotfunction = ggstrat,
  outdir = NULL,
  file_type = "png",
  dpi = 300,
  width = 4,
  height = 8,
  units = "in",
  ask = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.
Must include columns \code{stratsection_name}, and any other variables needed
for the plotfunction, such as: \code{stratlayer_order}, \code{grainsize},
\code{depth}, and \code{stratlayer_type}.}

\item{plotfunction}{A function that generates a plot for a single
section. It should accept at least two arguments: the full data
frame (\code{df}) and a section identifier (\code{stratsection_name}).
Defaults to \code{\link[=ggstrat]{ggstrat()}}.}

\item{outdir}{Directory where plots will be saved. Suggest supplying a name
such as \code{"StratSectionsPlotted"}, will create directory if it
does not exist.}

\item{file_type}{File extension for saved plots (e.g. \code{"png"},
\code{"pdf"}). Defaults to \code{"png"}.}

\item{dpi}{Plot resolution in dots per inch. Can be a numeric value
(e.g. \code{300}) or one of \code{"screen"}, \code{"print"}, or \code{"retina"}.
Defaults to \code{300}.}

\item{width}{Plot width passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. Defaults to \code{4}.}

\item{height}{Plot height passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. Defaults to \code{8}.}

\item{units}{Units for \code{width} and \code{height}. One of \code{"in"}, \code{"cm"},
or \code{"mm"}. Defaults to \code{"in"}.}

\item{ask}{Logical. If \code{TRUE} (default) and running interactively,
the function will prompt the user to confirm before generating
and saving all plots.}

\item{...}{Additional arguments passed on to \code{plotfunction}.}
}
\value{
Invisibly returns \code{NULL}. Called for its side effect of
saving plot files to disk.
}
\description{
Generate and save a series of stratigraphic plots, one per unique
stratigraphic section in the input data frame. The user can supply
any plotting function that returns a ggplot object (e.g. one of the
package's plotting functions, or a custom function).
}
\examples{
\donttest{
# Save plots for each section using the default ggstrat() function
td <- tempdir()
ggstrat_bulk_save(example_data_strat, outdir = td)

# Save plots using a different plotting function
ggstrat_bulk_save(example_data_strat,
                  plotfunction = ggstrat_column,
                  outdir = td)

# Save plots with higher resolution
ggstrat_bulk_save(example_data_strat,
                  outdir = td,
                  dpi = 600)

# Optional cleanup
unlink(list.files(td, full.names = TRUE))
}
}
