% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_layer_width.R
\name{add_layer_width}
\alias{add_layer_width}
\title{Reformat stratigraphic layer data for polygon plotting}
\usage{
add_layer_width(df, grainsize_direction = c("increasing", "decreasing"))
}
\arguments{
\item{df}{A data frame containing stratigraphic layer information. The
following columns are required:
\itemize{
\item \code{stratsection_name}: Unique identity of the section (repeated for each layer).
\item \code{stratlayer_name}: Unique identity of the layer.
\item \code{Depth_top}, \code{Depth_bottom}: Depths in centimeters, as returned by \code{add_depths()}.
\item \code{grainsize_top}: Grain size at the top of the layer.
\item \code{grainsize_bottom}: Grain size at the bottom of the layer.
}

Grain size values must be chosen from the validated list (White & Houghton,
2006, \emph{Geology} 34:677–680):
\itemize{
\item \code{"clay"} (<1/256 mm)
\item \code{"silt"} (1/256-1/16 mm)
\item \code{"very fine sand/ash"} (1/16-1/8 mm)
\item \code{"fine sand/ash"} (1/8-1/4 mm)
\item \code{"medium sand/ash"} (1/4-1/2 mm)
\item \code{"coarse sand/ash"} (1/2-1 mm)
\item \code{"very coarse sand/ash"} (1-2 mm)
\item \code{"granule/fine lapilli"} (2-4 mm)
\item \code{"pebble/medium lapilli"} (4-16 mm)
\item \code{"cobble/coarse lapilli"} (1.6-6.4 cm)
\item \code{"blocks/bombs/boulders"} (>6.4 cm)
\item \code{NA} (no data)
}

Several legacy abbreviations (e.g. \code{"vca"}, \code{"vcs"}) are currently accepted
but may be deprecated in future versions.}

\item{grainsize_direction}{Character string, one of \code{"increasing"} or
\code{"decreasing"}. Controls the numeric mapping of grain sizes:
\itemize{
\item \code{"increasing"} (default): clay/silt = 1, ..., blocks/bombs/boulders = 10.
\item \code{"decreasing"}: clay/silt = 10, ..., blocks/bombs/boulders = 1.
}
Increasing will show coarser units as bigger polygons (more prominent)
which is espeically useful for emphasizing more energentic volcanic deposits.
Decreasing will show finer (typically more resistive) units as bigger
which may better match observed erosional profiles.}
}
\value{
A tibble in long format with original data plus:
\itemize{
\item \code{size_loc}: identifier for polygon vertex locations.
\item \code{size_text}: original grain size text.
\item \code{depth}: numeric depth coordinate.
\item \code{grainsize}: numeric grain size code for plotting.
}
}
\description{
\code{add_layer_width()} reshapes stratigraphic layer grainsize data into a "long"
format suitable for plotting polygons in a stratigraphic section diagram. It
constructs left/right grain size boundaries, gathers them into long format,
assigns depth coordinates, and converts grain size text labels into numeric
values for plotting with \code{ggstrat()}.
}
\examples{
library(dplyr)
library(tidyr)
df <- tidyr::tibble(
stratlayer_order = c(1,2),
grainsize_top = c("clay", "coarse sand/ash"),
grainsize_bottom = c( "silt", "medium sand/ash"),
Depth_top = c(0, 10),
Depth_bottom = c(10, 20)
)
add_layer_width(df)

}
