% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qui_quadrado.R
\name{teste.qui}
\alias{teste.qui}
\title{Teste de qui-quadrado}
\usage{
teste.qui(
  var1,
  var2,
  titulo = "Teste Qui-Quadrado",
  x = NULL,
  y = "Proporcao",
  mostrar_tabela = TRUE,
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{var1}{Vetor categorico (grupo 1).}

\item{var2}{Vetor categorico (grupo 2).}

\item{titulo}{Titulo do grafico (string). Default: "Teste Qui-Quadrado".}

\item{x}{Rotulo do eixo x no grafico (string). Default: NULL (usa nome da variavel).}

\item{y}{Rotulo do eixo y no grafico (string). Default: "Proporcao".}

\item{mostrar_tabela}{Logico. Se TRUE, exibe a tabela de contingencia no console. Default: TRUE.}

\item{ajuda}{Logico. Se TRUE, exibe explicacao detalhada da funcao. Default: FALSE.}

\item{verbose}{Logico. Se TRUE, imprime mensagens sobre o teste e frequencias esperadas. Default: TRUE.}
}
\value{
Resultado do teste e tabela de contingencia.
}
\description{
Aplica o teste qui-quadrado ou Fisher para associacao entre duas variaveis categoricas.
}
\examples{
Grupo_Pacientes <- c(rep('A', 48), rep('B', 24))
Doente <- c(rep('A', 36), rep('B', 12), rep('A', 12), rep('B', 12))
teste.qui(Grupo_Pacientes, Doente)

}
