% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync}
\alias{am_sync}
\title{Bidirectional synchronization}
\usage{
am_sync(doc1, doc2)
}
\arguments{
\item{doc1}{First Automerge document}

\item{doc2}{Second Automerge document}
}
\value{
An integer indicating the number of sync rounds completed (invisibly).
Both documents are modified in place to include each other's changes.
}
\description{
Automatically synchronizes two documents by exchanging messages until
they converge to the same state. This is a high-level convenience function
that handles the entire sync protocol automatically.
}
\details{
The function exchanges sync messages back and forth between the two documents
until both sides report no more messages to send (\code{am_sync_encode()} returns \code{NULL}).
The Automerge sync protocol is mathematically guaranteed to converge.
}
\examples{
# Create two documents with different changes
doc1 <- am_create()
doc2 <- am_create()

# Make changes in each document
am_put(doc1, AM_ROOT, "x", 1)
am_put(doc2, AM_ROOT, "y", 2)

# Synchronize them (documents modified in place)
rounds <- am_sync(doc1, doc2)
rounds

# Now both documents have both x and y

am_close(doc1)
am_close(doc2)

}
