% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_merge}
\alias{am_merge}
\title{Merge changes from another document}
\usage{
am_merge(doc, other)
}
\arguments{
\item{doc}{Target document (will receive changes)}

\item{other}{Source document (provides changes)}
}
\value{
The target document \code{doc} (invisibly)
}
\description{
Merges all changes from another Automerge document into this one.
This is a one-way merge: changes flow from \code{other} into \code{doc},
but \code{other} is not modified. For bidirectional synchronization,
use \code{\link[=am_sync]{am_sync()}}.
}
\examples{
doc1 <- am_create()
doc2 <- am_create()

# Make changes in each document
am_put(doc1, AM_ROOT, "x", 1)
am_put(doc2, AM_ROOT, "y", 2)

# Merge doc2's changes into doc1
am_merge(doc1, doc2)

# Now doc1 has both x and y
am_close(doc1)
am_close(doc2)

}
