% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_load_incremental}
\alias{am_load_incremental}
\title{Load incremental changes into a document}
\usage{
am_load_incremental(doc, data)
}
\arguments{
\item{doc}{An Automerge document}

\item{data}{A raw vector containing incremental changes (from
\code{\link[=am_save_incremental]{am_save_incremental()}})}
}
\value{
The number of operations applied (numeric scalar, invisibly).
}
\description{
Applies incremental changes (from \code{\link[=am_save_incremental]{am_save_incremental()}}) to a document.
This is more efficient than loading a full document when only a few
changes need to be applied.
}
\examples{
doc1 <- am_create()
doc1$key <- "value"
am_commit(doc1)
bytes <- am_save(doc1)

doc1$key2 <- "value2"
am_commit(doc1)
incremental <- am_save_incremental(doc1)

# Load base document and apply incremental changes
doc2 <- am_load(bytes)
am_load_incremental(doc2, incremental)
doc2$key2  # "value2"

am_close(doc1)
am_close(doc2)

}
\seealso{
\code{\link[=am_save_incremental]{am_save_incremental()}}, \code{\link[=am_load]{am_load()}}
}
