% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_time}
\alias{am_change_time}
\title{Get the timestamp of a change}
\usage{
am_change_time(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}} or
\code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A \code{POSIXct} timestamp
}
\description{
Returns the timestamp recorded when the change was committed.
Note that timestamps are set by the committing peer and may not be
accurate if the peer's clock is wrong.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key", Sys.time())

history <- am_get_changes(doc)
am_change_time(history[[1]])

am_close(doc)

}
