% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{next_global_solar_eclipse}
\alias{next_global_solar_eclipse}
\title{Search for the next global solar eclipse}
\usage{
next_global_solar_eclipse(prev_eclipse_time)
}
\arguments{
\item{prev_eclipse_time}{A \code{POSIXct} time near a previous eclipse peak.}
}
\value{
A list with the same structure as \code{search_global_solar_eclipse}.
}
\description{
Finds the next solar eclipse in a series after the given eclipse time.
Typically, you pass the \code{peak} value from a previous
\code{search_global_solar_eclipse} or \code{next_global_solar_eclipse} call.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
eclipse1 <- search_global_solar_eclipse(start)
eclipse2 <- next_global_solar_eclipse(eclipse1$peak)
}
