% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_webanno_open.R
\name{webanno_open}
\alias{webanno_open}
\title{Open a WebAnno TSV v3.3 file.}
\usage{
webanno_open(path, cut_to_content = FALSE)
}
\arguments{
\item{path}{character. A path to a WebAnno TSV v3.3 file.}

\item{cut_to_content}{logical. Restrict the output file to those sentences containing
annotated labels and relations.}
}
\value{
WebAnnoTSV. A list of dataframes, each named after the corresponding paragraph in the text.
}
\description{
Read the contents of a WebAnno TSV 3.3 file, a format for annotated text containing named entities and relations.
}
\details{
One of the format types under use at \url{https://inception-project.github.io/}.
}
\examples{
example = system.file(paste0("extdata/insecta_annot_1.tsv"), package = "arete")

webanno_open(example)
}
