% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thicknessOf.R
\name{thicknessOf}
\alias{thicknessOf}
\title{Calculate Thickness of Horizons Matching Logical Criteria}
\usage{
thicknessOf(
  x,
  pattern = NULL,
  hzdesgn = hzdesgnname(x, required = TRUE),
  method = "cumulative",
  prefix = "",
  thickvar = "thickness",
  depthvars = horizonDepths(x),
  FUN = function(x, pattern, hzdesgn, ...) grepl(pattern, x[[hzdesgn]]),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{A \emph{SoilProfileCollection}}

\item{pattern}{\emph{character}. A pattern to match in \code{hzdesgn}; used with the default \code{FUN} definition for regular expression pattern matching on horizons.}

\item{hzdesgn}{\emph{character}. A column containing horizon designations or other horizon-level character label used to identify matches; used with the default \code{FUN} definition.}

\item{method}{\emph{character}. Either \code{"cumulative"} (default) or \code{"minmax"}. See details.}

\item{prefix}{\emph{character}. Column prefix for calculated \code{thickvar} (and \code{depthvar} for \code{method="minmax"}) column results. Default: \code{""}.}

\item{thickvar}{\emph{character} Length \code{1}. Column name to use for calculated thickness column. Default: \code{"thickness"}}

\item{depthvars}{\emph{character}. Length \code{2}. Column names to use for calculated minimum top depth and maximum bottom depth in \code{method="minmax"}. Default: \code{horizonDepths(x)}}

\item{FUN}{\emph{function}. A function that returns a \emph{logical} vector equal in length to the number of horizons in \code{x}. See details.}

\item{na.rm}{\emph{logical}. Omit \code{NA} values in summaries of thickness and in matching? Default: \code{FALSE}}

\item{...}{Additional arguments passed to the matching function \code{FUN}.}
}
\value{
A \emph{data.frame}-like object (corresponding to the \code{aqp_df_class()} of \code{x}) with one row per profile in \code{x}. First column is always the profile ID which is followed by \code{"thickness"}. In \code{method="minmax"} the upper and lower boundaries used to calculate \code{"thickness"} are also returned as \code{"tmin"} and \code{"tmax"} columns, respectively.
}
\description{
This function calculates the cumulative (\code{method="cumulative"}, default) or maximum difference between (\code{method="minmax"}) horizons within a profile that match a defined pattern (\code{pattern}) or, more generally, any set of horizon-level logical expressions encoded in a function (\code{FUN}).
}
\details{
The two thickness methods currently available are:
\itemize{
\item \code{method="cumulative"} (default): cumulative thickness of horizons where \code{FUN} returns true
\item \code{method="minmax"}: maximum bottom depth minus minimum top depth of horizons where \code{FUN} returns true
}

If a custom function (\code{FUN}) is used, it should accept arbitrary additional arguments via an ellipsis (\code{...}).
It is not necessary to do anything with arguments, but the result should match the number of horizons found in the input SoilProfileCollection \code{x}.
}
\examples{
data("jacobs2000")

# cumulative thickness of horizon designations matching "Bt"
thicknessOf(jacobs2000, "Bt")

# maximum bottom depth minus minimum top depth of horizon designations matching "Bt"
thicknessOf(jacobs2000, "Bt", prefix = "Bt_", method = "minmax")

# cumulative thickness of horizon designations matching "A|B"
thicknessOf(jacobs2000, "A|B", prefix = "AorB_")

# maximum bottom depth minus minimum top depth of horizon designations matching "A|B"
thicknessOf(jacobs2000, "A|B", method = "minmax", prefix = "AorB_")
# note that the latter includes the thickness of E horizons between the A and the B

# when using a custom function (be sure to accept ... and consider the effect of NA values)

# calculate cumulative thickness of horizons containing >18\% clay
thicknessOf(jacobs2000, prefix = "claygt18_", 
            FUN = function(x, ...) !is.na(x[["clay"]]) & x[["clay"]] > 18)

}
