% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.aplms.R
\name{influence.aplms}
\alias{influence.aplms}
\title{local influence analysis of the object `aplms()`}
\usage{
\method{influence}{aplms}(
  model,
  perturbation = c("case-weight", "dispersion", "response", "explanatory", "corAR"),
  part = TRUE,
  ...
)
}
\arguments{
\item{model}{an object with the result of fitting additive partial linear models with symmetric errors.}

\item{perturbation}{A string vector specifying a perturbation scheme: `case-weight`, `dispersion`, `response`, `explanatory`, and `corAR`.}

\item{part}{A logical value to indicate whether the influential analysis is performed for \eqn{\gamma}, \eqn{\phi} and \eqn{\rho}.}

\item{...}{other arguments.}
}
\value{
A list object containing the conformal normal curvature of the specified perturbations.
}
\description{
Takes a fitted `aplms` object and outputs some diagnostic information about the fitting procedure and results. Returns the conformal normal curvature of the fitted `aplms` model object. The `case-weight`, `dispersion`, `response`, `explanatory`, and `corAR` perturbations are available.
}
\examples{
data(temperature)
temperature.df = data.frame(temperature,time=1:length(temperature))
model<-aplms::aplms(temperature ~ 1,
                   npc=c("time"), basis=c("cr"),Knot=c(60),
                   data=temperature.df,family=Powerexp(k=0.3),p=1,
                   control = list(tol = 0.001,
                                  algorithm1 = c("P-GAM"),
                                  algorithm2 = c("BFGS"),
                                  Maxiter1 = 20,
                                  Maxiter2 = 25),
                   lam=c(10))
influence(model, perturbation = c("case-weight"))
}
