% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_logLik.R
\name{plot_logLik}
\alias{plot_logLik}
\alias{plot_logLik.aphylo}
\alias{plot_logLik.formula}
\alias{plot_logLik.aphylo_estimates}
\title{Plot Log-Likelihood function of the model}
\usage{
plot_logLik(x, sets, ...)

\method{plot_logLik}{aphylo}(x, sets, ...)

\method{plot_logLik}{formula}(x, sets, ...)

\method{plot_logLik}{aphylo_estimates}(x, sets, ...)
}
\arguments{
\item{x}{An object of class \code{\link[=aphylo]{aphylo()}}}

\item{sets}{(optional) Character matrix of size \verb{2 x # of combinations}.
contains the names of the pairs to plot. If nothing passed, the function will
generate all possible combinations as \code{combn(names(params), 2)}.}

\item{...}{Aditional parameters to be passed to \code{plotfun}.}
}
\value{
NULL (invisible). Generates a plot of the loglikelihood of the model.
}
\description{
Plot Log-Likelihood function of the model
}
\examples{
# Loading data
data(fakeexperiment)
data(faketree)
O <- new_aphylo(fakeexperiment[,2:3], tree = as.phylo(faketree))

# Baseline plot (all parameters but Pi)
plot_logLik(O)

# No psi parameter
plot_logLik(O ~ mu_d + Pi + eta)

}
