% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.r
\name{bind}
\alias{bind}
\alias{rbind.annmatrix}
\alias{cbind.annmatrix}
\title{Bind several annmatrix Objects Together}
\usage{
\method{rbind}{annmatrix}(...)

\method{cbind}{annmatrix}(...)
}
\arguments{
\item{...}{(generalized) vector or matrix objects}
}
\value{
a single annmatrix object resulting from binding all the inputs together
}
\description{
Implementation of \code{rbind} and \code{cbind} methods for annmatrix objects.
}
\details{
All the inputs are bound together in exact same way as if all the annmatrix objects were regular matrices.
Then, the row and column annotations of the supplied annmatrix objects are merged together.
Missing annotations are filled in using 'NA' values.

For demonstration purposes only \code{rbind} will be described with \code{cbind} behaving accordingly.

1) Matrix.
The obtained matrix will be exactly the same as calling \code{rbind} with all annmatrix objects replaced by regular matrices.

2) Column annotations.
When \code{rbind} is called the matrices are all assumed to have the same set of columns.
Hence, the column annotations are assumed to be shared between all provided annmatrix objects.
Thus, in order to retain all possible column annotations, they are merged together.
This way any column annotation field present in at least one of the provided annmatrix objects will be present in the final result.
In case of conflicts, when the same annotation field is present in multiple annmatrix objects but contains different values, the first occuring instance is selected and an appropriate warning is displayed.
Non-annmatrix objects are assumed to share the column annotations present in supplied annmatrix objects.

3) Row annotations.
When \code{rbind} is called the matrices are assumed to have a separate unique set of rows.
Hence no conflicts between annotation values are possible for row annotations.
In order to retain all possible row annotations, row annotations are merged together.
Thus, the resulting row annotation data frame will have as many fields as there were unique row annotation fields among all the provided annmatrix objects.
Unlike with column annotations, if a particular annmatrix only had a subset of the final collection of annotation fields, then the missing fields are added and the annotation is filled with NA values.
All the rows associated with non-annmatrix objects will have missing (NA) values for all the annotation fields.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

X1 <- X[1:10,]
X2 <- X[11:20,]
all.equal(X, rbind(X1, X2))

X1 <- X[,1:5]
X2 <- X[,6:10]
all.equal(X, cbind(X1, X2))

X11 <- X[1:10, 1:5]
X21 <- X[11:20, 1:5]
X12 <- X[1:10, 6:10]
X22 <- X[11:20, 6:10]
all.equal(X, cbind(rbind(X11, X21), rbind(X12, X22)))

}
\author{
Karolis Koncevičius
}
