% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_huc}
\alias{calculate_huc}
\title{Calculate HUC covariates}
\usage{
calculate_huc(from, locs, locs_id = "site_id", geom = FALSE, ...)
}
\arguments{
\item{from}{SpatVector(1). Output from \code{process_huc()}.}

\item{locs}{data.frame. character to file path, SpatVector, or sf object.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract HUC IDs at point locations. Returns a \code{data.frame}
object containing \code{locs_id} and HUC IDs.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_huc(
  from = huc, # derived from process_huc() example
  locs = loc,
  locs_id = "id",
  geom = FALSE
)
}
}
\seealso{
\code{\link[=process_huc]{process_huc()}}
}
\author{
Insang Song
}
