% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_blackmarble_corners}
\alias{process_blackmarble_corners}
\title{Process Black Marble corners}
\usage{
process_blackmarble_corners(hrange = c(5, 11), vrange = c(3, 6))
}
\arguments{
\item{hrange}{integer(2). Both should be in 0-35.}

\item{vrange}{integer(2). Both should be in 0-17.}
}
\value{
\code{data.frame} with xmin, xmax, ymin, and ymax fields
}
\description{
Tile corner generator for Black Marble products.

Black Marble products are in HDF5 format and are read without
georeference with typical R geospatial packages.
This function generates a \code{data.frame} of corner coordinates for assignment.
}
\examples{
process_blackmarble_corners(hrange = c(1, 2), vrange = c(1, 2))
}
\references{
\itemize{
\item \href{https://ladsweb.modaps.eosdis.nasa.gov/api/v2/content/archives/Document\%20Archive/Science\%20Data\%20Product\%20Documentation/VIIRS_Black_Marble_UG_v1.3_Sep_2022.pdf}{Wang, Z. (2022). Black Marble User Guide (Version 1.3). NASA.}
}
}
\author{
Insang Song
}
\keyword{internal}
