% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{signal_select}
\alias{signal_select-method}
\alias{signal_slice}
\alias{signal_slice-method}
\alias{signal_select,numeric,numeric-method}
\alias{signal_select,ANY,missing-method}
\alias{signal_slice,numeric,numeric-method}
\alias{signal_slice,ANY,missing-method}
\title{Subset}
\usage{
signal_select(x, y, ...)

signal_slice(x, y, ...)

\S4method{signal_select}{numeric,numeric}(x, y, from, to)

\S4method{signal_select}{ANY,missing}(x, from, to)

\S4method{signal_slice}{numeric,numeric}(x, y, subset)

\S4method{signal_slice}{ANY,missing}(x, subset)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{from, to}{A \code{\link{numeric}} value giving the first and last value (in \code{x}
unit) to be selected.}

\item{subset}{An \code{\link{integer}} vector giving either positive values to keep,
or negative values to drop. The values provided must be either all
positive or all negative (coerced to integer as by \code{\link[=as.integer]{as.integer()}}).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
\itemize{
\item \code{signal_select()} allows to subset by values of \code{x}.
\item \code{signal_slice()} allows to subset by position along \code{x}.
}
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Subset from 2.75 keV to 200 keV
BEGe_1 <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe_1, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Subset from the 20th to the 1250th value
BEGe_2 <- signal_slice(BEGe, subset = 20:1250)

## Plot spectrum
plot(BEGe_2, type = "l", xlab = "Energy (keV)", ylab = "Count")
}
\seealso{
Other signal processing methods: 
\code{\link{signal_bind}()},
\code{\link{signal_correct}()},
\code{\link{signal_drift}()},
\code{\link{signal_mean}()},
\code{\link{signal_shift}()}
}
\author{
N. Frerebeau
}
\concept{signal processing methods}
