% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential.R
\name{sampler.exponential}
\alias{sampler.exponential}
\title{Method to sample from an \code{exponential} object.}
\usage{
\method{sampler}{exponential}(x, ...)
}
\arguments{
\item{x}{The \code{exponential} object to sample from.}

\item{...}{Additional arguments to pass (not used)}
}
\value{
A function that allows sampling from the exponential
distribution. Accepts an argument \code{n} denoting sample
size and \code{rate} denoting the failure rate. Defaults to
the failure rate of object \code{x}.
}
\description{
Method to sample from an \code{exponential} object.
}
\examples{
x <- exponential(rate = 2)
s <- sampler(x)
set.seed(42)
s(5)
}
