% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_dist.R
\name{inv_cdf.empirical_dist}
\alias{inv_cdf.empirical_dist}
\title{Method for obtaining the inverse CDF (quantile function) of a univariate
\code{empirical_dist} object.}
\usage{
\method{inv_cdf}{empirical_dist}(x, ...)
}
\arguments{
\item{x}{The empirical distribution object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function that accepts a vector of probabilities \code{p} and returns
the corresponding quantiles.
}
\description{
Uses the empirical quantile function from the observed data.
}
\examples{
ed <- empirical_dist(c(1, 2, 3, 4, 5))
qf <- inv_cdf(ed)
qf(0.5)       # median
qf(c(0.25, 0.75)) # quartiles
}
