% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_dist.R
\name{inv_cdf.beta_dist}
\alias{inv_cdf.beta_dist}
\title{Inverse CDF (quantile function) for a beta distribution.}
\usage{
\method{inv_cdf}{beta_dist}(x, ...)
}
\arguments{
\item{x}{A \code{beta_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(p, lower.tail = TRUE, log.p = FALSE, ...)}
returning the quantile at probability \code{p}.
}
\description{
Returns a function that computes quantiles of the beta distribution.
}
\examples{
x <- beta_dist(2, 5)
q <- inv_cdf(x)
q(0.5)
q(0.95)
}
