% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{conditional.mixture}
\alias{conditional.mixture}
\title{Conditional distribution of a mixture.}
\usage{
\method{conditional}{mixture}(x, P = NULL, ..., given_indices = NULL, given_values = NULL)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{P}{Optional predicate function for MC fallback.}

\item{...}{Additional arguments.}

\item{given_indices}{Integer vector of observed variable indices.}

\item{given_values}{Numeric vector of observed values.}
}
\value{
A \code{mixture} or \code{empirical_dist} object.
}
\description{
For a mixture of distributions that support closed-form conditioning
(e.g. MVN), uses Bayes' rule to update the mixing weights:
\deqn{w_k' \propto w_k f_k(x_{given})}
where \eqn{f_k} is the marginal density of component \eqn{k} at the
observed values. The component conditionals are computed via
\code{conditional(component_k, given_indices = ..., given_values = ...)}.
}
\details{
Falls back to MC realization if \code{P} is provided or if any
component does not support \code{given_indices}/\code{given_values}.
}
\examples{
# Closed-form conditioning on MVN mixture
m <- mixture(
  list(mvn(c(0, 0), diag(2)), mvn(c(3, 3), diag(2))),
  c(0.5, 0.5)
)
# Condition on X2 = 1
mc <- conditional(m, given_indices = 2, given_values = 1)
mean(mc)
}
