% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{affine_transform}
\alias{affine_transform}
\title{Affine transformation of a normal or multivariate normal distribution.}
\usage{
affine_transform(x, A, b = NULL)
}
\arguments{
\item{x}{A \code{normal} or \code{mvn} distribution object.}

\item{A}{A numeric matrix (or scalar for univariate).}

\item{b}{An optional numeric vector (or scalar) for the offset. Default is
a zero vector.}
}
\value{
A \code{normal} or \code{mvn} distribution.
}
\description{
Computes the distribution of \eqn{AX + b} where \eqn{X \sim MVN(\mu, \Sigma)}.
The result is \eqn{MVN(A\mu + b, A \Sigma A^T)}.
}
\details{
For a univariate \code{normal}, scalars \code{A} and \code{b} are promoted
to 1x1 matrices and scalar internally. Returns a \code{normal} if the
result is 1-dimensional.
}
\examples{
X <- mvn(c(0, 0), diag(2))
# Project to first component via 1x2 matrix
Y <- affine_transform(X, A = matrix(c(1, 0), 1, 2), b = 5)
mean(Y)

# Scale a univariate normal
Z <- affine_transform(normal(0, 1), A = 3, b = 2)
mean(Z)
vcov(Z)
}
