% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alfred_series.R
\name{get_alfred_series}
\alias{get_alfred_series}
\title{Accessing ALFRED}
\usage{
get_alfred_series(
  series_id,
  series_name = NULL,
  observation_start = NULL,
  observation_end = NULL,
  realtime_start = NULL,
  realtime_end = NULL,
  api_key = NULL
)
}
\arguments{
\item{series_id}{FRED times series ID.}

\item{series_name}{Choose a name for the series column in output. Default: series_id.}

\item{observation_start}{Date of first observation in "yyyy-mm-dd" format. Default: Earliest observation available.}

\item{observation_end}{Date of last observation in "yyyy-mm-dd" format. Default: Last observation available.}

\item{realtime_start}{Date of first real time period in "yyyy-mm-dd" format. Default: First vintage date available.}

\item{realtime_end}{Date of last real time period in "yyyy-mm-dd" format. Default: Last vintage date available.}

\item{api_key}{You can supply your own apikey obtained via \url{https://fredaccount.stlouisfed.org/login/secure/)}
if you want to run a large batch of requests. Otherwise you might run into query limits of the API.}
}
\description{
This function can pull time series from the ALFRED database: \url{https://alfred.stlouisfed.org}.
Downloading different vintages for performing real-time analysis is provided.
}
\details{
FRED time series IDs can be found on the respective site in ALFRED, e.g. \url{https://alfred.stlouisfed.org/series?seid=CPIAUCSL}.
}
\examples{
\dontrun{
    get_alfred_series("INDPRO", "indpro")
    }
\dontrun{
    get_alfred_series("INDPRO", "indpro",
    realtime_start = "2008-10-31", realtime_end = "2009-10-31")
    }
}
\keyword{alfred}
