% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btaNeeded2.R
\name{btaNeeded2}
\alias{btaNeeded2}
\title{Function to compute log rate ratio needed (fixed sample size)}
\usage{
btaNeeded2(
  N,
  thta,
  L,
  alp = 0.05,
  pow = 0.8,
  ar = 0.5,
  frailty.type = c("unblind", "blind"),
  interval = c(log(0.5), log(1))
)
}
\arguments{
\item{N}{Sample size.}

\item{thta}{Variance of frailty parameter. If frailty.type = "blind", assumes thta derives from pooled model; if frailty.type = "unblind" assumes thta is from correctly specified model. Default "unblind".}

\item{L}{Number of events}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total)}

\item{frailty.type}{Indicates whether frailty variance is based on blinded information ("blind") or unblinded ("unblind"). Default "unblind".}

\item{interval}{Initial search interval for bta1.}
}
\value{
The log rate ratio.
}
\description{
Function to compute log rate ratio needed to achieve target power at one-sided Type I control level alp/2. Useful to compute critical value (set pow = 0.5).
}
\details{
This function computes the log rate ratio bta1 as the root of the equation pow2(bta1, N, thta_, L, alp, ar) - pow = 0, where thta_ depends on bta1 if using estimates from blinded analyses.
If frailty.type = "blind": thta_ = thtap2thta(thta, bta1); otherwise if frailty = "unblind": thta_ = thta.
Function assumes a rate ratio < 1 is favourable to treatment.
}
\examples{

# Based on unblinded estimates

# Based on blinded estimates
btaNeeded2(N = 1000, thta = 2, L = 1000, alp = c(0.01, 0.05), pow = c(.5), frailty.type = "bl")
exp(btaNeeded2(N = 1000, thta = 2, L = 1000, alp = c(0.01, 0.05), pow = c(.5), frailty.type = "bl"))


}
