% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_afcharts.R
\name{use_afcharts}
\alias{use_afcharts}
\title{Use afcharts defaults.}
\usage{
use_afcharts(
  default_colour = afcharts::af_colour_values["dark-blue"],
  ...,
  reset = FALSE
)
}
\arguments{
\item{default_colour}{Default colour/fill for geoms. Default value is 'blue'
from \code{af_colour_values}.}

\item{...}{Arguments passed to \code{theme_af()}.}

\item{reset}{Logical. Turn off use_afcharts. This aims to reset the default
chart setting to their status when \code{use_afcharts} was first called.}
}
\value{
NULL. Function is used for side effects of setting ggplot2 plot
theme, colour palette and geom aesthetic defaults.
}
\description{
Set afcharts theme, colour palette and geom aesthetic defaults
for ggplot2 charts.
}
\examples{
library(ggplot2)

d <- subset(mpg, manufacturer == "ford")

ggplot(d, aes(x = model)) + geom_bar()
ggplot(d, aes(x = model, fill = class)) + geom_bar()

use_afcharts()

ggplot(d, aes(x = model)) + geom_bar()
ggplot(d, aes(x = model, fill = class, colour = class)) + geom_bar()

}
