% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{tidy_ghg_analyzer}
\alias{tidy_ghg_analyzer}
\title{tidy_ghg_analyzer}
\usage{
tidy_ghg_analyzer(file_path, gas, analyzer = "licor")
}
\arguments{
\item{file_path}{Directory of file.}

\item{gas}{Choose between CO2/CH4 or N2O LI-COR Trace Gas Analyzer, which is "ch4" and "n2o", respectively.}

\item{analyzer}{The brand of the analyzer which the data was downloaded from.}
}
\value{
Return the loaded XLSX file after tidying for further analysis.
}
\description{
Tidy the data downloaded from GHG Analyzer.
}
\examples{
ghg_data_path <- system.file("extdata", "ch4.xlsx", package = "aelab")
tidy_ghg_analyzer(ghg_data_path, "ch4")
}
