% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_point}
\alias{plot_point}
\title{plot_point}
\usage{
plot_point(
  df,
  x,
  y,
  z = NULL,
  base_size = 25,
  point_size = 3,
  stroke_size = 1,
  text_color = "black",
  facet = FALSE,
  facet_x = NULL,
  facet_y = NULL,
  style = "bw"
)
}
\arguments{
\item{df}{A data frame.}

\item{x}{<[`data-masking`][ggplot2::aes]> Column mapped to the x-axis.}

\item{y}{<[`data-masking`][ggplot2::aes]> Column mapped to the y-axis.}

\item{z}{<[`data-masking`][ggplot2::aes]> Optional column mapped to fill colour.}

\item{base_size}{Base font size passed to the ggplot2 theme. Default 25.}

\item{point_size}{Point size. Default 3.}

\item{stroke_size}{Point stroke width. Default 1.}

\item{text_color}{Text colour. Default \code{"black"}.}

\item{facet}{Logical; add facet grid? Default \code{FALSE}.}

\item{facet_x}{Column name (string) for the horizontal facet dimension.}

\item{facet_y}{Column name (string) for the vertical facet dimension.}

\item{style}{Theme style. One of \code{"bw"}, \code{"minimal"},
\code{"classic"}, \code{"graycolor"}, \code{"light"}. Default \code{"bw"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a scatter plot using the aelab theme.
}
\examples{
\dontrun{
df <- data.frame(x = 1:5, y = c(2,4,1,5,3), g = c("A","A","B","B","A"))
plot_point(df, x, y, g)
}
}
