% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hobo_do.R
\name{combine_weather_month}
\alias{combine_weather_month}
\title{combine_weather_month}
\usage{
combine_weather_month(file_path, start_month, end_month, year = 2024, zone)
}
\arguments{
\item{file_path}{Path prefix (directory + filename prefix before the date
portion, e.g. \code{"data/weather/"}).}

\item{start_month}{First month to import (1–9; two-digit months not yet
supported).}

\item{end_month}{Last month to import.}

\item{year}{Four-digit year. Default 2024.}

\item{zone}{Character label for the weather station / region.}
}
\value{
A combined data frame produced by \code{\link{process_weather_month}}.
}
\description{
Batch-import monthly weather CSV files from a Taiwan Central
  Weather Administration station for a consecutive range of months.
}
\details{
File names are expected to follow the pattern
  \code{<file_path><year>-0<month>.csv} (e.g. \code{2024-01.csv}).
}
\examples{
\dontrun{
df <- combine_weather_month("data/weather/", start_month = 1,
                            end_month = 6, year = 2024, zone = "site_A")
}
}
