% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_test_norm_local.R
\name{sample_size_norm_local}
\alias{sample_size_norm_local}
\title{Calculate sample size or power for a locally efficient adaptive design.}
\usage{
sample_size_norm_local(
  overall_sig_level = 0.025,
  min_effect_size = 1,
  sample_size = TRUE,
  effect_size = 1,
  time = 0,
  target_power = 0.8,
  final_time = 0,
  tol_sample_size = 1e-08,
  input_check = TRUE
)
}
\arguments{
\item{overall_sig_level}{Overall significance level in (0, 1). Default is 0.025.}

\item{min_effect_size}{The minimum effect size.  It should be positive. The working test will be constructed to have the power of \code{1 - work_beta} for this effect size.  Default is 1.}

\item{sample_size}{If \code{TRUE}, the function will return the sample size required by the locally efficient adaptive design to have the power of \code{target_power}. If \code{FALSE}, the function will return the power when the final interim analysis and the final analysis are conducted at \code{time} and \code{final_time}, respectively.}

\item{effect_size}{The effect size, on the basis of which the power or sample size calculation will be performed. In locally efficient adaptive designs, any real value no less than \code{min_effect_size / 2} is allowed.}

\item{time}{The time of the current analysis.}

\item{target_power}{The power, on the basis of which the sample size calculation will be performed.}

\item{final_time}{The time of the final analysis.}

\item{tol_sample_size}{The precision in calculation of the sample size.}

\item{input_check}{Indicate whether or not the arguments input by user contain invalid values.}
}
\value{
It returns the sample size (when \code{sample_size = TRUE}) or the power (when \code{sample_size = FALSE}).
}
\description{
\code{sample_size_norm_local} calculates the power if the time of the final
analysis is given and otherwise the sample size.
The computed power for \code{effect_size} is an approximate lower bound.
Sample size is also calculated on the basis of the bound.
}
\seealso{
\code{\link{adaptive_analysis_norm_local}} for example of this function.
}
